
<?php
include '../connection.php';

session_start(); // Ensure session is started

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

$id = $_GET['offer_id'] ?? 0;

// Prepare SQL statement
$sql = "SELECT adp.*, se.sim_name, d.dist_name 
        FROM all_drive_package adp
        JOIN sim_entry se ON adp.offer_sim = se.sim_id
        JOIN district d ON adp.offer_area = d.dist_id 
        WHERE adp.offer_id = ?"; // Specify the table alias

$stmt = $con->prepare($sql);

if ($stmt === false) {
    die('Prepare failed: ' . htmlspecialchars($con->error));
}

$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    die('No offer found with this ID.');
}

// The rest of your code goes here...

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userid = $_SESSION['userid'];
    $offer_rqst = $_POST['offer_rqst'];
    $mobile = $_POST['mobile'];
    $pin = $_POST['pin'];
    $status = 'Pending';
    $date = date('Y-m-d');

    // Check the balance for the user
    $sqlCheckBalance = "SELECT amount FROM balance WHERE userid = ?";
    $stmtCheckBalance = $con->prepare($sqlCheckBalance);
    $stmtCheckBalance->bind_param("i", $userid);
    $stmtCheckBalance->execute();
    $stmtCheckBalance->bind_result($balance);
    $stmtCheckBalance->fetch();
    $stmtCheckBalance->close();

    // Check the PIN from the student table
    $sqlCheckPin = "SELECT pin FROM student WHERE userid = ?";
    $stmtCheckPin = $con->prepare($sqlCheckPin);
    $stmtCheckPin->bind_param("i", $userid);
    $stmtCheckPin->execute();
    $stmtCheckPin->bind_result($storedPin);
    $stmtCheckPin->fetch();
    $stmtCheckPin->close();

    // Validate the conditions
    if ($balance >= $row['offer_amount']) {
        if ($storedPin === $pin) {
            // Prepare the SQL statement to insert into the drive_package_rqst table
            $sqlInsertTopup = "INSERT INTO drive_package_rqst (userid, offer_rqst, mobile_no, status, date)
                               VALUES (?, ?, ?, ?, ?)";
            $stmtInsertTopup = $con->prepare($sqlInsertTopup);

            if ($stmtInsertTopup === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            // Binding parameters for the insert
            $stmtInsertTopup->bind_param("issss", $userid, $offer_rqst, $mobile, $status, $date);

            if ($stmtInsertTopup->execute()) {
                $_SESSION['message'] = "রিকোয়েস্ট সফল হয়েছে"; // Request successful
            } else {
                $_SESSION['message'] = "দু:খিত! পুনরায় চেষ্টা করুন"; // Sorry! Please try again
            }

            $stmtInsertTopup->close();
        } else {
            $_SESSION['message'] = "আপনার পিন নম্বর সঠিক নয়"; // Your PIN number is incorrect
        }
    } else {
        $_SESSION['message'] = "আপনার অ্যাকাউন্টে পর্যাপ্ত টাকা নেই"; // You do not have sufficient balance in your account
    }

    // Close connection
    $con->close();

    // Redirect back to the appropriate page
    header("Location: index.php");
    exit();
}
?>

<!-- The rest of your HTML code remains unchanged -->



<?php include 'header-link.php' ?>

<main>
    <section>
        <div class="container mt-5 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <h5 class="card-title text-center"> অফার ক্রয় নিশ্চিত করুন </h5>
                            
                                <div class="offer-card mb-3 p-4">
                                    <div class="row flex-row">
                                        <div class="col-md-12 text-center">
                                            <strong class="fw-bold"> অফার: <?php echo htmlspecialchars($row['offer_name']); ?> </strong><br>
                                            <p> মেয়াদ: <?php echo htmlspecialchars($row['offer_meyad']); ?> </p>
                                            <p class="fw-bold"> মূল্য: <?php echo htmlspecialchars($row['offer_amount']); ?> ৳ </p>
                                            <p> কমিশন: <?php echo htmlspecialchars($row['offer_commision']); ?> ৳ </p>
                                            <p class="fw-bold"> সর্বমোট : <?php echo htmlspecialchars($row['drive_total']); ?> ৳ </p>
                                            <p> সিম: <?php echo htmlspecialchars($row['sim_name']); ?> </p>
                                            <p> বিভাগ: <?php echo htmlspecialchars($row['dist_name']); ?> </p>
                                        </div>
									</div>	
								</div>
										

                                <div class="my-3">
									<form class="form" action="" method="POST">
                                            <input type="hidden" name="offer_rqst" value="<?php echo htmlspecialchars($row['offer_id']); ?>">
                                            <div class="mb-1">
                                                <label for="inputField" class="form-label"> মোবাইল  নং </label>
                                                <input type="text" pattern="^[0-9]{11}$" class="form-control" name="mobile" id="inputField" placeholder=" মোবাইল  নং..." required>
												<center>
												<small > সঠিক মোবাইল নাম্বার লিখুন   </small>
											</center>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label for="pinField" class="form-label"> পিন </label>
                                                <input type="text" class="form-control" name="pin" id="pinField" placeholder=" পিন..." required>
                                            </div>
                                            
                                            <div class="d-grid">
                                                <button type="submit" class="btn custom-button w-50 mx-auto mb-3"> কনফার্ম করুন </button>
                                            </div>
                                        </form>	
								
								</div>
                                   
                                
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

</body>
</html>
